package ga.examples;

import ga.core.algorithm.automatic.SGAGeneration;
import ga.core.individual.IIndividualFactory;
import ga.core.individual.TemplateIndividualFactory;
import ga.core.individual.population.ArrayListPopulation;
import ga.core.selection.TournamentSelector;
import ga.examples.quadratic.QuadraticEvaluator;
import ga.examples.quadratic.QuadraticIndividual;
import ga.examples.quadratic.QuadraticOnePointCrossoverOp;
import ga.examples.quadratic.QuadraticPointMutationOp;

import java.util.logging.Logger;

public final class QuadraticFunctionExample {

  // the logger for this class
  private static final Logger LOGGER = Logger
      .getLogger(QuadraticFunctionExample.class.getName());

  private QuadraticFunctionExample() {
  }

  public static void main(final String[] args) {
    final IIndividualFactory<QuadraticIndividual> factory = new TemplateIndividualFactory<QuadraticIndividual>(
        new QuadraticIndividual());
    final ArrayListPopulation<QuadraticIndividual> population = new ArrayListPopulation<QuadraticIndividual>(
        factory, 20);

    final QuadraticEvaluator evaluator = new QuadraticEvaluator(42);
    final TournamentSelector<QuadraticIndividual> selector = new TournamentSelector<QuadraticIndividual>(
        3);
    final QuadraticOnePointCrossoverOp crossOverOp = new QuadraticOnePointCrossoverOp(
        25);
    final QuadraticPointMutationOp mutationOp = new QuadraticPointMutationOp(15);

    final SGAGeneration<QuadraticIndividual> algorithm = new SGAGeneration<QuadraticIndividual>(
        population, evaluator, selector, mutationOp, crossOverOp, true);

    algorithm.init();

    for (int i = 0; i <= 1000; i++) {
      LOGGER.info("Generation " + i);
      LOGGER.info(algorithm.getPopulation().toString());
      algorithm.step();

      final QuadraticIndividual fittest = algorithm.getPopulation()
          .getFittestIndividual();
      LOGGER.info("Fittest: " + fittest);

      if (fittest.getResult() == evaluator.getTarget()) {
        LOGGER.info("Generation " + i);
        break;
      }
    }
  }
}
